/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于界面跳转 针对于子页面弹出关闭
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.11
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_router_page */


/* global $ */
/* global g_obj_lang */
/* global mc_loading_wait_remove */


/************************************************************************************************
* 类型:
*    构造函数
* 功能:
*    解析界面数据 , 存储获取不同界面数据
* 参数:
*    NA
* 返回：
*    NA
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
function mc_router_page() {
    // 地址
    var m_obj_top_page_data = {};
    // 子页面数据
    var m_obj_child_page_data = {};
    // 页面dom存储 内置使用 从弹窗第一层开始存 box_main那层iframe不存如
    var m_arr_page_jq_html = [];
    // 页面宽度存储 内置使用
    var m_arr_page_width = [];
    // 子页面下标
    var m_arr_page_index = -1;
    // 子页面window对象 针对箱体大屏连接界面
    var m_obj_window_child_page = {};
    // 同级界面window对象 用于界面相互调用方法
    var m_obj_peer_page_window = {};


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    存入需要弹出子页面所需的数据
* 参数:
*     @param {Promise<Object>} obj_msg 箱体链接页面生成数据
* 返回：
*     @return {Promise<boolean>} true false
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    this.set_popup_layer_msg = function (obj_msg) {
        if (!obj_msg || "[object Object]" !== Object.prototype.toString.call(obj_msg)) {
            return false;
        }
        m_obj_top_page_data = obj_msg;
        return true;
    };


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    弹出子页面
* 参数:
*     @param {Promise<Object>} obj_msg 箱体链接页面生成数据
* 返回：
*     @return {Promise<boolean>} true false
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    this.open_popup_layer = function () {
        if (!m_obj_top_page_data || "[object Object]" !== Object.prototype.toString.call(m_obj_top_page_data)) {
            return false;
        }
        mc_iframe_popout(m_obj_top_page_data);
        return true;
    };


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    清空内存数据
* 参数:
*     NA
* 返回：
*     NA
* 备注：
*     用于打开新界面 去掉上次的数据
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    this.clear_msg = function () {
        // 弹层对象数据;
        m_obj_top_page_data = {};
        // 子页面数据;
        m_obj_child_page_data = {};
        // 页面dom存储;
        m_arr_page_jq_html = [];
        // 页面宽度存储;
        m_arr_page_width = [];
        // 子页面下标;
        m_arr_page_index = -1;
        // 子页面window对象
        m_obj_window_child_page = {};
    };


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     存入子界面数据
* 参数:
*    @param {Promise<Object>} obj_data 子页面参数需传get其他界面使用
* 返回：
*    @return {Promise<boolean>} true / false
* 备注：
*     自行定义 set什么get什么
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    this.set_child_page_data = function (obj_data) {
        if (!obj_data) {
            return false;
        }

        m_obj_child_page_data = obj_data;
        return true;
    };

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     获取子界面数据
* 参数:
*     NA
* 返回：
*    @return {Promise<object>} m_obj_child_page_data 子页面数据
* 备注：
*     自行定义 set什么get什么 针对箱体大屏连接界面的子页面
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    this.get_child_page_data = function () {
        if (!m_obj_child_page_data || "{}" === m_obj_child_page_data) {
            return false;
        }
        return m_obj_child_page_data;
    };


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     存入页面window对象
* 参数:
*    @param {Promise<Object>} obj_data 子页面window对象
*    @param {Promise<boolean>} b_bind 用于是否添加滑入滑出事件
* 返回：
*    @return {Promise<boolean>} true / false
* 备注：
*     自行定义 set什么get什么 针对箱体大屏连接界面的子页面
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    this.set_child_page_window = function (obj_data, b_bind) {
        if (!obj_data) {
            return false;
        }

        m_obj_window_child_page = obj_data;
        // 添加点击界面滑出界面事件
        if (b_bind) {
            mc_add_onclick_page_for_cancel(obj_data);
        }
        return true;
    };

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     存入页面window对象
* 参数:
*    @param {Promise<Object>} obj_win 子页面window对象
* 返回：
*    @return {Promise<boolean>} true / false
* 备注：
*     仅用于同层界面之间的方法调用 (不用于箱体大屏连接及其界面弹层)
*     配合 mc_use_peer_page_funk函数使用
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.18
*      内容 : 所有代码
************************************************************************************************/
    this.set_peer_page_window = function (obj_win) {
        if (!obj_win) {
            return false;
        }
        m_obj_peer_page_window = obj_win;
        return true;
    };

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     存入页面window对象
* 参数:
*    @param {Promise<Object>} str_funk_name 子页面window对象
*    @param {Promise<string>} param1 调用函数参数
*    @param {Promise<string>} param2 调用函数参数
*    @param {Promise<string>} param3 调用函数参数
*    @param {Promise<string>} param4 调用函数参数
* 返回：
*    @return {Promise<boolean>} true / false
* 备注：
*     仅用于同层界面之间的方法调用 (不用于箱体大屏连接及其界面弹层)
*     配合 set_peer_page_window 函数调用
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.18
*      内容 : 所有代码
************************************************************************************************/
    this.mc_use_peer_page_funk = function (str_funk_name, param1, param2, param3, param4) {
        if (!str_funk_name) {
            return false;
        }
        if (!m_obj_peer_page_window[str_funk_name](param1, param2, param3, param4)) {
            return false;
        }
        return true;
    };

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     获取页面window对象
* 参数:
*     无
* 返回：
*    @return {Promise<Object>}
*       null 不存在
*       window
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2021.06.15
*      内容 : 所有代码
************************************************************************************************/
    this.get_page_window = function () {
        if ("[object Window]" !== Object.prototype.toString.call(m_obj_window_child_page)) {
            return null;
        }
        return m_obj_window_child_page;
    };

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     调用子页面方法 主要针对箱体大屏连接界面
* 参数:
*    @param {Promise<Object>} str 需调用的方法名称
*    @param {Promise<Object>} param1 被调用的函数参数
*    @param {Promise<Object>} param2 被调用的函数参数
*    @param {Promise<Object>} param3 被调用的函数参数
*    @param {Promise<Object>} param4 被调用的函数参数
*    @param {Promise<Object>} param5 被调用的函数参数
*    @param {Promise<Object>} param6 被调用的函数参数
*    @param {Promise<Object>} param7 被调用的函数参数
*    @param {Promise<Object>} param8 被调用的函数参数
* 返回：
*    @return {Promise<Object>}
null 调用失败 / 函数内部错误
result 返回数据
* 备注：
*     自行定义 set什么get什么 针对箱体大屏连接界面的子页面
*     目前添加到8个函数参数 若有多则可继续添加
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.15
*      内容 : 所有代码
************************************************************************************************/
    this.set_methods_for_call = function (str, param1, param2, param3, param4, param5, param6, param7, param8) {
        if (!str || "{}" === m_obj_window_child_page) {
            return null;
        }

        var result = m_obj_window_child_page[str](param1, param2, param3, param4, param5, param6, param7, param8);

        // 调用方法
        if (!result) {
            return null;
        }

        return result;
    };


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     关闭所有弹窗
* 参数:
*    @param {Promise<Function>} fun_callback 关闭界面后回调
* 返回：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.15
*      内容 : 所有代码
************************************************************************************************/
    this.set_close_all_layer = function (fun_callback) {
        // window.layer.closeAll();
        // m_obj_child_page_data = {};
        // m_obj_top_page_data = {};
        if (document.getElementById("mc_loading_box")) {
            mc_loading_wait_remove();
        }
        // for (var id = 0; id < m_arr_page_jq_html.length; id++) {
        // eslint-disable-next-line no-loop-func
        mc_cancel_iframe_page("", function () {
            $(m_arr_page_jq_html[0]).remove();
            $($(".layui-layer-shade")[0]).remove();
            m_arr_page_jq_html.pop();
            m_arr_page_width.pop();
            fun_callback();
        });
        return;
        // }
    };

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*     删除当前打开的最后最后一个界面 (针对打开的iframe层)
* 参数:
*    @param {Promise<Object>} ui_idx 判断当前关闭遮罩的顺序 关闭 m_arr_page_jq_html下标下的界面 不传数值则从最后一个开始删
* 返回：
*    @returns {Promise<Boolean>} true/false
* 备注：
*     仅做删除处理 不做子页面删除后的操作
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.15
*      内容 : 所有代码
************************************************************************************************/
    this.mc_cancel_last_page = function (ui_idx) {
        return mc_cancel_last_page_insert(ui_idx);
    };

    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    layer.open iframe窗口封装
* 参数:
*    @param {Promise<Object>} params 询问框参数字串
*    @param {Promise<Boolean>} b_main_popout true 为main页面弹框 可为空
* 参数备注:
*    params = {
*      icon: 标题icon图标类: string,
*      title: 标题文本: string,
*      url: 打开页面链接: string
*      area: 窗口大小:array, 此项可为空 默认:["98%", "98%"] [宽,高]
*      iframe_close: 窗口关闭后回调函数名 :string, 此项可为空
*      iframe_cancel_close: 窗口右上角关闭回调函数名 :string, 此项可为空
*      set_max_width: 设置iframe窗口最大宽度 :string, 此项可为空 (目前不使用)
*      set_min_width: 设置iframe窗口最小宽度 :string, 此项可为空
*      set_min_height: 设置iframe窗口最小高度 :string, 此项可为空
*      set_max_height: 设置iframe窗口最大高度 :string, 此项可为空 (目前不使用)
*      set_isoutanim: true 开启关闭动画 :boolean 此项可为空 默认关闭延迟动画
*      open_pot: 打开位置: object, 此项可为空 默认main页打开
*      set_shade: 设置遮罩: number, 此项可为空 默认0.5 不设置遮罩时置0
*      set_move: 设置弹层是否可拖拽: boolean, 此项可为空 默认false 不可移动;'.layui-layer-title'按住标题拖拽
*      set_offset: 设置弹层坐标: String/Array，此项可为空 默认：垂直水平居中
*      b_reduce_head: 去掉头部高度 默认48px (用于移动端) true 去掉 false 不减
*      skin: 滑入滑出样式 区别: main层的弹框标记st main层下的iframe层下的弹框标记nd (类名代表层次)
*    }
*    所有文本传入语言ID
* 返回：
*    @returns {Promise<Boolean>}
*     true 设置成功
*     false 参数有误
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    function mc_iframe_popout(params, b_main_popout) {
        if ("object" !== typeof params) {
            return false;
        }
        var str_combo_title = "<div class='" + params.icon + "'><span class='layer_title' lang_id='" + params.title + "' style='margin-left:10px;'>" + g_obj_lang.get_item_val(params.title) +
            "</span></div>";
        var b_isOutAnim = false;
        var o_window = window;
        var ui_shade = 0.5;

        // 弹层偏移距离
        var op_width = "";

        if (params.set_isoutanim) {
            b_isOutAnim = true;
        }
        // if (params.open_pot) {
        //     o_window = params.open_pot;
        // }
        if ("number" === typeof params.set_shade) {
            ui_shade = params.set_shade;
        }

        if (!params.area) {
            params.area = ["300px", "100%"];
        }

        // 从右滑出 (移动端/pc端)
        params.set_offset = "rt";

        var str_skin_class = params.skin;

        // 以防万一界面未处理
        if (!str_skin_class) {
            params.skin = "layui-anim layui-anim-rl layui-layer-adminRight level_st";
            str_skin_class = params.skin;
        }


        var ui_layer = o_window.layer.open({
            skin: params.skin,
            type: 2,
            title: str_combo_title,
            shadeClose: false,
            shade: ui_shade,
            area: params.area,
            resize: false,
            move: false,
            content: params.url,
            isOutAnim: b_isOutAnim,
            offset: params.set_offset || "auto",
            cancel: function () {
                // 滑动弹窗
                mc_cancel_iframe_page("", function () {
                    mc_close_page_funk(params.iframe_cancel_close, b_main_popout);
                    mc_handle_cancel_last_page_and_shade();
                    if (document.getElementById("mc_loading_box")) {
                        mc_loading_wait_remove();
                    }
                    // 窗口关闭回调
                    mc_close_page_funk(params.iframe_close, b_main_popout);
                });

                return false;
            },
            end: function () {
                return false;
            }

        });

        var obj_iframe = o_window.document.getElementById("layui-layer" + ui_layer);

        var jq_dom = $(obj_iframe);

        op_width = jq_dom.outerWidth();

        for (var idx = m_arr_page_jq_html.length - 1; 0 <= idx; idx--) {
            if (0 === m_arr_page_jq_html[idx].children.length) {
                m_arr_page_jq_html.pop();
                m_arr_page_width.pop();
            }
        }

        m_arr_page_jq_html.push(jq_dom[0]);
        m_arr_page_width.push(op_width);

        obj_iframe.style.left = (Number(obj_iframe.style.left.slice(0, -2)) + op_width) + "px";

        // 移动端点击遮罩关闭
        // if (!b_phone_stauts) {
        $(".layui-layer-shade").off("click").on("click", function () {
            // 滑动弹窗
            mc_cancel_iframe_page("", function () {
                mc_close_page_funk(params.iframe_cancel_close, b_main_popout);
                mc_handle_cancel_last_page_and_shade();
                mc_close_page_funk(params.iframe_close, b_main_popout);
                if (document.getElementById("mc_loading_box")) {
                    mc_loading_wait_remove();
                }
            });
        });


        window.onresize = function () {
            mc_layer_on_resize();
        };

        return true;
    }

    // 封装关闭函数
    function mc_close_page_funk(funk_name, b_main_popout) {
        if (funk_name && "" !== funk_name) {
            // 关闭iframe窗口 当前层语言
            if (mc_whether_in_iframe_popout()) {
                mc_popout_callback(b_main_popout, funk_name, true);
            } else {
                mc_popout_callback(b_main_popout, funk_name);
            }
        }
    }


    // 监听界面变化 移动端/pc端都要监听
    function mc_layer_on_resize() {
        var arr_main_st_dom = document.getElementsByClassName("layui-layer-iframe");
        var ui_main_st_cnt = arr_main_st_dom.length;

        for (var idx_st = 0; idx_st < ui_main_st_cnt; idx_st++) {
            $(arr_main_st_dom[idx_st]).removeClass("layui-anim-rl");
        }
    }

    /* 关闭弹出层界面 包括内置弹层和外置弹层 */
    function mc_cancel_iframe_page(b_keydown, fun_callback) {
        if (!m_arr_page_jq_html[m_arr_page_jq_html.length - 1]) {
            if ("[OBJECT FUNCTION]" === Object.prototype.toString.call(fun_callback).toUpperCase()) {
                fun_callback();
            }
            return;
        }
        if (b_keydown) {
            m_arr_page_jq_html[m_arr_page_jq_html.length - 1].children[2].children[0].click();
        } else {
            $(m_arr_page_jq_html[m_arr_page_jq_html.length - 1]).animate({ left: "+=" + m_arr_page_width[m_arr_page_width.length - 1] + "px" }, 500, "linear", function () {
                // console.log("1");
                fun_callback();
                return;
            });
        }
        return;
    }


    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    判定当前是否在iframs弹层页 更新弹层页下标 （最上层下标）
* 参数:
*    无
* 返回：
*    @returns {Promise<Boolean>}
*     true 在iframe弹层页
*     false 不在iframe弹层页
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    function mc_whether_in_iframe_popout() {
        var obj_iframe = document.getElementsByClassName("layui-layer-iframe");
        var ui_max_index = -1;

        if (0 !== obj_iframe.length) {
            if (1 === obj_iframe.length) {
                m_arr_page_index = parseInt(obj_iframe[0].getAttribute("times"), 10);
                return true;
            }
            for (var idx = 0; idx < obj_iframe.length; idx++) {
                var ui_index = parseInt(obj_iframe[idx].getAttribute("times"), 10);

                if (ui_max_index < ui_index) {
                    ui_max_index = ui_index;
                }
            }
            if (-1 !== ui_max_index) {
                m_arr_page_index = ui_max_index;
                return true;
            }
        }
        return false;
    }


    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    判定当前弹框调用的函数为本页面还是二级页面并执行
* 参数:
*    @param {Promise<Boolean>} b_main_popout 正在main页面 为true
*    @param {Promise<String>} str_callback 调用的函数名
*    @param {Promise<Boolean>} b_iframe_popout 正在iframe弹层页面
*    @param {Promise<Function>} fn_callback 标识是否正在关闭iframe弹层页询问框 参数为true回调关闭iframe弹层页
* 返回：
*    @returns {Promise<Function>}
*     fn_callback(true) 正在关闭iframe弹层页的询问按钮
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    function mc_popout_callback(b_main_popout, str_callback, b_iframe_popout, fn_callback) {
        var mc_page_method = null;

        // main
        if (b_main_popout) {
            mc_page_method = window[str_callback];
        }
        // iframe
        if (b_iframe_popout) {
            if (mc_whether_in_iframe_popout()) {
                mc_page_method = $("#layui-layer-iframe" + m_arr_page_index)[0].contentWindow[str_callback];
            }
        }
        // page
        if (!b_main_popout && !b_iframe_popout) {
            // mc_page_method = document.getElementById("iframe_content_subpage").contentWindow[str_callback];
            mc_page_method = mc_get_bto_fun(str_callback);
        }
        if (mc_page_method) {
            mc_page_method();
            if (fn_callback) {
                return fn_callback(b_iframe_popout);
            }
        }
        return true;
    }

    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    返回底层iframe函数
* 参数:
*    @param {Promise<String>} str_fun_name 函数名
* 返回：
*    @returns {Promise<Function>}
*     匹配函数
*     false 无此函数
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.11
*      内容 : 所有代码
************************************************************************************************/
    function mc_get_bto_fun(str_fun_name) {
        if ("string" !== typeof str_fun_name || 0 === str_fun_name.length) {
            return false;
        }
        var elem_iframe = document.getElementsByTagName("iframe")[0].contentWindow;

        while (elem_iframe) {
            if ("undefined" !== typeof (elem_iframe[str_fun_name])) {
                return elem_iframe[str_fun_name];
            } else if (elem_iframe.document.getElementsByTagName("iframe")[0] && elem_iframe !== elem_iframe.document.getElementsByTagName("iframe")[0].contentWindow) {
                elem_iframe = elem_iframe.document.getElementsByTagName("iframe")[0].contentWindow;
            } else {
                return false;
            }
        }
        return false;
    }


    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    用于绑定全局界面dom事件(外部)
* 参数:
*    @param {Promise<object>} obj_win 全局window对象
* 返回：
*    NA
*     匹配函数
*     false 无此函数
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.19
*      内容 : 所有代码
************************************************************************************************/
    function mc_add_onclick_page_for_cancel(obj_win) {
        // return;
        var iframe_dom = obj_win.document;
        // 顶部栏
        var top_dom = document.getElementById("page_title");
        // 侧边栏
        var side_dom = document.getElementById("mc_side_bto_btn");
        // 底部栏
        var footer_dom = document.getElementsByClassName("mc_footer")[0];
        // iframe 顶部
        var iframe_top_dom = iframe_dom.getElementsByClassName("mc_edit_gp_scroll")[0];
        // iframe 底部
        var iframe_footer_dom = iframe_dom.getElementsByClassName("mc_btn_group")[0];

        side_dom.addEventListener("click", mc_add_event, false);
        top_dom.addEventListener("click", mc_add_event, false);
        footer_dom.addEventListener("click", mc_add_event, false);
        iframe_top_dom.addEventListener("click", mc_add_event, false);
        iframe_footer_dom.addEventListener("click", mc_add_event, false);
    }

    // 点击事件触发
    function mc_add_event(event) {
        if (mc_click_blank(event)) {
            // 针对大屏箱体界面关闭界面回调
            if ("[object Function]" !== Object.prototype.toString.call(m_obj_window_child_page.mc_close_all_layer_init_data)) {
                m_obj_window_child_page = m_obj_window_child_page.window;
            }
            // 执行关闭前回调
            if (m_obj_window_child_page.mc_close_all_layer_init_data) {
                m_obj_window_child_page.mc_close_all_layer_init_data();
            } else {
                mc_cancel_last_page_insert();
            }
        }
    }

    /************************************************************************************************
* 类型:
*    函数(外部)
* 功能:
*    封装关闭最后一个界面 或某个界面
* 参数:
*    @param {Promise<Number>} ui_order 删除弹层的下标 (无则从最后一个弹层开始删除)
* 返回：
*    @return {Promise<boolean>} true/false
* 备注:
*    主要针对关闭关闭弹窗前后弹出提示语 用于关闭正确的弹层
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.19
*      内容 : 所有代码
************************************************************************************************/
    function mc_cancel_last_page_insert(ui_order) {
        if (0 === m_arr_page_jq_html.length || 0 === m_arr_page_width.length) {
            return false;
        }
        $(m_arr_page_jq_html[m_arr_page_jq_html.length - 1]).animate({ left: "+=" + m_arr_page_width[m_arr_page_width.length - 1] + "px" }, 500, "linear", function () {
            if (ui_order) {
                if (1 === m_arr_page_jq_html.length) {
                    $(m_arr_page_jq_html[0]).remove();
                    $($(".layui-layer-shade")[0]).remove();
                    m_arr_page_jq_html.pop();
                    m_arr_page_width.pop();
                } else {
                    $(m_arr_page_jq_html[ui_order]).remove();
                    $($(".layui-layer-shade")[ui_order]).remove();
                    m_arr_page_jq_html = m_arr_page_jq_html.splice(ui_order - 1, 1);
                    m_arr_page_width = m_arr_page_width.splice(ui_order - 1, 1);
                }
            } else {
                mc_handle_cancel_last_page_and_shade();
            }
            if (document.getElementById("mc_loading_box")) {
                mc_loading_wait_remove();
            }
        });
        return true;
    }

    // 进一步删除弹层和对应的阴影部分 避免关闭错误遮罩影响操作
    function mc_handle_cancel_last_page_and_shade() {
        var dom_page = m_arr_page_jq_html[m_arr_page_jq_html.length - 1];
        var str_page_time_id = dom_page.getAttribute("times");

        $(dom_page).remove();

        var dom_shade = $(".layui-layer-shade");

        for (var idx = 0; idx < dom_shade.length; idx++) {
            var str_shade_time_id = dom_shade[idx].getAttribute("times");

            if (str_shade_time_id === str_page_time_id) {
                $(dom_shade[idx]).remove();
            }
        }
        m_arr_page_jq_html.pop();
        m_arr_page_width.pop();
    }
}


/************************************************************************************************
* 类型:
*    函数(外部)
* 功能:
*    用于检测当前点击界面的位置
* 参数:
*    @param {Promise<object>} event 事件触发对象
* 返回：
*    @return {Promise<boolean>} true/false
* 备注:
*     针对大屏箱体界面的弹层关闭
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.06.19
*      内容 : 所有代码
************************************************************************************************/
function mc_click_blank(event) {
    // var str_onclick_param = event.target.getAttribute("onclick");
    var str_class_name = event.target.className;
    var str_class_name_curr_target = event.currentTarget.className;
    var b_right = false;

    // 头部
    if (-1 !== str_class_name_curr_target.indexOf("mc_border_bottom_line ") || -1 !== str_class_name.indexOf("mc_border_bottom_line")) {
        b_right = true;
    }

    // 侧边栏
    if (-1 !== str_class_name.indexOf("mc_hide_scrollbar") || -1 !== str_class_name.indexOf("mc_side_shortcut") || -1 !== str_class_name.indexOf("mc_side_footer ")) {
        b_right = true;
    }

    //画布的头部
    if (-1 !== str_class_name.indexOf("mc_edit_gp_wrap") || -1 !== str_class_name.indexOf("mc_spilt_div_vertical") || -1 !== str_class_name.indexOf("mc_item_text") || -1 !== str_class_name.indexOf("mc_item_wrap")) {
        b_right = true;
    }

    // 画布的底部
    if (-1 !== str_class_name.indexOf("mc_btn_group") || -1 !== str_class_name.indexOf("mc_btn_group_left") || -1 !== str_class_name.indexOf("mc_btn_group_right")) {
        b_right = true;
    }
    // 界面的底部
    if (-1 !== str_class_name.indexOf("mc_footer")) {
        b_right = true;
    }

    return b_right;
}


